package pangea.hiagent.agent.data;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;

/**
 * 带熔断和重试能力的从Agent包装类
 */
public class CircuitBreakerSlaveAgent implements SlaveAgent {
    private final SlaveAgent delegate;
    private final CircuitBreaker circuitBreaker;
    private final Retry retry;

    public CircuitBreakerSlaveAgent(SlaveAgent delegate,
                                    CircuitBreakerRegistry circuitBreakerRegistry,
                                    RetryRegistry retryRegistry) {
        this.delegate = delegate;
        String agentName = delegate.getClass().getSimpleName();
        // 熔断配置：默认失败率50%触发熔断，熔断时间10秒
        this.circuitBreaker = circuitBreakerRegistry.circuitBreaker(agentName);
        // 重试配置：默认3次重试，指数退避策略
        this.retry = retryRegistry.retry(agentName);
    }

    @Override
    public AgentResult execute(SubTask subTask) {
        return Retry.decorateSupplier(retry,
                CircuitBreaker.decorateSupplier(circuitBreaker,
                        () -> delegate.execute(subTask))).get();
    }

    @Override
    public AgentResult fallback(SubTask subTask, Exception e) {
        return delegate.fallback(subTask, e);
    }
}