CREATE TABLE IF NOT EXISTS agent_task_status (
    task_id VARCHAR(64) PRIMARY KEY COMMENT '任务唯一标识',
    status VARCHAR(32) NOT NULL COMMENT '任务状态：READY/RUNNING/SUCCESS/FAIL',
    dependencies VARCHAR(256) COMMENT '依赖子任务ID，逗号分隔',
    result TEXT COMMENT '任务结果JSON字符串',
    result_hash VARCHAR(64) COMMENT '结果MD5哈希值，用于校验完整性',
    retry_count INT DEFAULT 0 COMMENT '已重试次数',
    timeout BIGINT COMMENT '任务超时时间戳',
    update_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '状态更新时间'
);

-- 创建任务状态索引，提升查询效率
CREATE INDEX idx_task_status ON agent_task_status(status);
CREATE INDEX idx_task_update_time ON agent_task_status(update_time);