package pangea.hiagent.web.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

/**
 * 思考事件数据传输对象
 * 用于表示Agent的思考过程事件
 */
@Data
@EqualsAndHashCode(callSuper = true)
@SuperBuilder
@NoArgsConstructor
@AllArgsConstructor
public class ThoughtEvent extends WorkPanelEvent {
    private static final long serialVersionUID = 1L;
    
    /**
     * 思考内容
     */
    private String content;
    
    /**
     * 思考类型（分析、规划、执行等）
     */
    private String thinkingType;
}