package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 文档片段实体类
 * 用于存储文档分片信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("document_chunk")
public class DocumentChunk extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 关联的文档ID
     */
    private String documentId;
    
    /**
     * 文档内容
     */
    private String content;
    
    /**
     * 页码
     */
    private Integer pageNumber;
    
    /**
     * 相似度得分
     */
    private Double score;
    
    /**
     * 序号
     */
    private Integer sequence;
    
    /**
     * 向量ID
     */
    private Long vectorId;
    
    /**
     * 元数据（JSON格式）
     */
    private String metadata;
}