package pangea.hiagent.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

/**
 * 定时器配置DTO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TimerConfigDto {
    private String id;
    
    @NotBlank(message = "定时器名称不能为空")
    private String name;
    
    private String description;
    
    @NotBlank(message = "Cron表达式不能为空")
    private String cronExpression;
    
    @NotNull(message = "启用状态不能为空")
    private Integer enabled;
    
    @NotBlank(message = "关联Agent ID不能为空")
    private String agentId;
    
    private String agentName;
    
    private String promptTemplate;
    
    private String paramsJson;
    private LocalDateTime lastExecutionTime;
    private LocalDateTime nextExecutionTime;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
    private String createdBy;
}
