package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * OAuth2 账户关联实体类
 * 记录用户与第三方 OAuth2 提供者的账户关联信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("oauth2_account")
public class OAuth2Account implements Serializable {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 主键 ID
     */
    private String id;
    
    /**
     * 关联的本地用户 ID
     */
    private String userId;
    
    /**
     * OAuth2 提供者名称
     */
    private String providerName;
    
    /**
     * 第三方平台的用户 ID
     */
    private String remoteUserId;
    
    /**
     * 第三方平台的用户名
     */
    private String remoteUsername;
    
    /**
     * 第三方平台的邮箱
     */
    private String remoteEmail;
    
    /**
     * 访问令牌（Access Token）
     */
    private String accessToken;
    
    /**
     * 刷新令牌（Refresh Token）
     */
    private String refreshToken;
    
    /**
     * 令牌过期时间
     */
    private Long tokenExpiry;
    
    /**
     * 授权的权限范围
     */
    private String scope;
    
    /**
     * 第三方平台返回的用户信息（JSON 格式）
     */
    private String profileData;
    
    /**
     * 账户关联时间
     */
    private Long linkedAt;
    
    /**
     * 最后登录时间
     */
    private Long lastLoginAt;
    
    /**
     * 创建时间
     */
    private Long createdAt;
    
    /**
     * 更新时间
     */
    private Long updatedAt;
    
    /**
     * 删除标志
     */
    private Integer deleted;
}
