package pangea.hiagent.repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import pangea.hiagent.model.Agent;

/**
 * Agent Repository接口
 */
@Mapper
public interface AgentRepository extends BaseMapper<Agent> {
    
    /**
     * 查找活跃的Agent（明确指定所有列名以避免MyBatis自动转换问题）
     */
    @Select("SELECT id,name,description,status,default_model,system_prompt,prompt_template,temperature,max_tokens,top_p,top_k,presence_penalty,frequency_penalty,history_length,tools,rag_collection_id,enable_rag,enable_re_act,owner,created_at,updated_at,created_by,updated_by,deleted,remark FROM agent WHERE owner = #{owner} AND status = 'active' ORDER BY created_at DESC")
    java.util.List<Agent> findActiveAgentsByOwner(@Param("owner") String owner);
    
    /**
     * 查找活跃的Agent（使用created_at列）- 修复create_time错误的备用方法
     */
    @Select("SELECT id,name,description,status,default_model,system_prompt,prompt_template,temperature,max_tokens,top_p,top_k,presence_penalty,frequency_penalty,history_length,tools,rag_collection_id,enable_rag,enable_re_act,owner,created_at,updated_at,created_by,updated_by,deleted,remark FROM agent WHERE owner = #{owner} AND status = 'active' ORDER BY created_at DESC")
    java.util.List<Agent> findActiveAgentsByOwnerWithExplicitColumns(@Param("owner") String owner);
    
    /**
     * 分页查询优化
     */
    IPage<Agent> selectPageWithOptimization(Page<Agent> page, @Param("ew") com.baomidou.mybatisplus.core.conditions.Wrapper<Agent> wrapper);
}