package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 工具实体类
 * 用于存储工具的配置信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("tool")
public class Tool extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 工具名称（唯一标识）
     */
    private String name;
    
    /**
     * Spring Bean名称（用于查找对应的实例）
     * 例如: "searchTool", "oauth2AuthorizationTool", "fileProcessingTool"
     * 这个名称一定要与Spring中的@Component或@Bean声明的bean名称一致
     */
    private String beanName;
    
    /**
     * 工具显示名称
     */
    private String displayName;
    
    /**
     * 工具描述
     */
    private String description;
    
    /**
     * 工具分类
     */
    private String category;
    
    /**
     * 工具状态（active/inactive）
     */
    private String status;
    
    /**
     * 参数定义（JSON格式）
     */
    private String parameters;
    
    /**
     * 返回值类型
     */
    private String returnType;
    
    /**
     * 返回值结构（JSON格式）
     */
    private String returnSchema;
    
    /**
     * 实现代码
     */
    private String implementation;
    
    /**
     * 超时时间（毫秒）
     */
    private Long timeout;
    
    /**
     * API端点URL
     */
    private String apiEndpoint;
    
    /**
     * HTTP方法（GET/POST/PUT/DELETE）
     */
    private String httpMethod;
    
    /**
     * 请求头（JSON格式）
     */
    private String headers;
    
    /**
     * 认证类型
     */
    private String authType;
    
    /**
     * 认证配置（JSON格式）
     */
    private String authConfig;
    
    /**
     * 工具所有者
     */
    private String owner;
}