import request from '@/utils/request'

interface TaskParams {
  taskName: string
  taskType: string
  masterAgent: string
  slaveAgents: string[]
  params?: string
  dependencies?: string
}

interface TaskRetryResponse {
  code: number
  message: string
  data?: any
}

/**
 * 多Agent协同服务
 */
export const multiAgentService = {
  /**
   * 获取协同任务统计信息
   */
  getCollaborationStats() {
    return request.get('/agent/collaboration/stats')
  },

  /**
   * 获取协同任务列表
   */
  getCollaborationTasks(params: {
    page: number
    size: number
    status?: string
    keyword?: string
  }) {
    return request.get('/agent/collaboration/tasks', { params })
  },

  /**
   * 获取任务详情
   */
  getTaskDetail(taskId: string) {
    return request.get(`/agent/collaboration/tasks/${taskId}`)
  },

  /**
   * 创建协同任务
   */
  createTask(taskParams: TaskParams) {
    return request.post('/agent/collaboration/tasks', taskParams)
  },

  /**
   * 重试任务
   */
  retryTask(taskId: string): Promise<TaskRetryResponse> {
    return request.post(`/agent/collaboration/tasks/${taskId}/retry`)
  },

  /**
   * 获取Agent统计信息
   */
  getAgentStats() {
    return request.get('/agent/stats')
  },

  /**
   * 获取主Agent列表
   */
  getMasterAgents() {
    return request.get('/agent?types=master')
  },

  /**
   * 获取从Agent列表
   */
  getSlaveAgents() {
    return request.get('/agent?types=slave')
  }
}