// 时间轴工具函数库

/**
 * 检查是否为工具事件类型
 * @param type 事件类型
 * @returns 是否为工具事件类型
 */
export function isToolEventType(type: string): boolean {
  return ['tool_call', 'tool_result', 'tool_error'].includes(type);
}

/**
 * 检查工具输入是否有效
 * @param event 事件对象
 * @returns 工具输入是否有效
 */
export function hasValidToolInput(event: any): boolean {
  return event.type === 'tool_call' && (event.toolInput !== null && event.toolInput !== undefined || event.params !== null && event.params !== undefined);
}

/**
 * 检查工具输出是否有效
 * @param event 事件对象
 * @returns 工具输出是否有效
 */
export function hasValidToolOutput(event: any): boolean {
  return (event.type === 'tool_result' || event.type === 'tool_call') && 
         (event.toolOutput !== null && event.toolOutput !== undefined || 
          event.result !== null && event.result !== undefined);
}

/**
 * 截断标题
 * @param title 标题
 * @param maxLength 最大长度
 * @returns 截断后的标题
 */
export function truncateTitle(title: string, maxLength: number = 30): string {
  if (!title) return '';
  return title.length > maxLength ? title.substring(0, maxLength) + '...' : title;
}