// 聊天消息类型定义
export interface Message {
  content: string;
  isUser: boolean;
  agentId?: string;
  timestamp: number;
  isStreaming: boolean;
  hasError?: boolean;
  originalMessage?: string;
}

// 智能体类型定义
export interface Agent {
  id: string;
  name: string;
  [key: string]: any;
}

// SSE事件数据类型定义
export interface SSEData {
  type: string;
  token?: string;
  content?: string;
  thinkingType?: string;
  toolName?: string;
  toolAction?: string;
  toolInput?: any;
  toolOutput?: any;
  toolStatus?: string;
  executionTime?: number;
  embedUrl?: string;
  embedType?: string;
  embedTitle?: string;
  embedHtmlContent?: string;
  metadata?: Record<string, any>;
  [key: string]: any;
}

// SSE行处理上下文类型
export interface SSEProcessingContext {
  accumulatedContentRef: { value: string };
  hasFinalAnswerRef: { value: boolean };
  currentEventRef: { value: string };
  aiMessageIndex: number;
  resetStreamTimeout: () => void;
}
