package pangea.hiagent.agent.data;

import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.retry.RetryRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 从Agent自动配置类，为所有从Agent添加熔断重试能力
 */
@Configuration
public class SlaveAgentAutoConfig {

    @Bean
    public List<SlaveAgent> slaveAgents(List<SlaveAgent> rawAgents,
                                        CircuitBreakerRegistry circuitBreakerRegistry,
                                        RetryRegistry retryRegistry) {
        return rawAgents.stream()
                .map(agent -> new CircuitBreakerSlaveAgent(agent, circuitBreakerRegistry, retryRegistry))
                .collect(Collectors.toList());
    }
}