package pangea.hiagent.agent.data;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

/**
 * 模块配置属性类，支持配置热更新
 */
@Data
@Component
@RefreshScope
@ConfigurationProperties(prefix = "agent.module")
public class ModuleProperties {
    
    /**
     * 模块总开关
     */
    private boolean enabled = true;
    
    /**
     * 日志审计模块配置
     */
    private LogModuleProperties log = new LogModuleProperties();
    
    /**
     * 结果校验模块配置
     */
    private CheckModuleProperties check = new CheckModuleProperties();
    
    /**
     * 任务可视化模块配置
     */
    private MonitorModuleProperties monitor = new MonitorModuleProperties();
    
    /**
     * 降级兜底模块配置
     */
    private FallbackModuleProperties fallback = new FallbackModuleProperties();
    
    /**
     * 缓存管理模块配置
     */
    private CacheModuleProperties cache = new CacheModuleProperties();
    
    /**
     * 任务调度模块配置
     */
    private TaskSchedulerModuleProperties scheduler = new TaskSchedulerModuleProperties();
    
    /**
     * 性能监控模块配置
     */
    private PerformanceMonitorModuleProperties performance = new PerformanceMonitorModuleProperties();
    
    /**
     * 安全审计模块配置
     */
    private SecurityAuditModuleProperties security = new SecurityAuditModuleProperties();
    
    /**
     * 日志审计模块配置属性
     */
    @Data
    public static class LogModuleProperties {
        private boolean enabled = true;
        private int retentionDays = 30; // 日志保留天数
        private String storagePath = "./logs"; // 日志存储路径
    }
    
    /**
     * 结果校验模块配置属性
     */
    @Data
    public static class CheckModuleProperties {
        private boolean enabled = true;
        private boolean strictMode = false; // 严格模式，校验失败时抛出异常
        private boolean retryOnFailure = false; // 校验失败时是否重试
        private String algorithm = "SHA-256"; // 校验算法
    }
    
    /**
     * 任务可视化模块配置属性
     */
    @Data
    public static class MonitorModuleProperties {
        private boolean enabled = true;
        private int refreshInterval = 5000; // 监控刷新间隔（毫秒）
        private boolean enableGraph = true; // 是否启用依赖图
    }
    
    /**
     * 降级兜底模块配置属性
     */
    @Data
    public static class FallbackModuleProperties {
        private boolean enabled = true;
        private int maxRetries = 3; // 最大重试次数
        private long retryDelay = 1000; // 重试延迟（毫秒）
        private String defaultStrategy = "cache"; // 默认降级策略
    }
    
    /**
     * 缓存模块配置属性
     */
    @Data
    public static class CacheModuleProperties {
        private boolean enabled = true;
        private String cacheType = "caffeine"; // caffeine, redis, ehcache
        private int maxSize = 1000;
        private long taskCacheTtl = 300000L; // 任务缓存TTL: 5分钟
        private long resultCacheTtl = 600000L; // 结果缓存TTL: 10分钟
        private long configCacheTtl = 3600000L; // 配置缓存TTL: 1小时
        private boolean enableStatistics = true;
        private boolean enableEviction = true;
    }
    
    /**
     * 任务调度模块配置属性
     */
    @Data
    public static class TaskSchedulerModuleProperties {
        private boolean enabled = true;
        private String strategy = "priority"; // priority, round-robin, weighted
        private int maxConcurrentTasks = 10;
        private long taskTimeout = 300000L; // 5分钟
    }
    
    /**
     * 性能监控模块配置属性
     */
    @Data
    public static class PerformanceMonitorModuleProperties {
        private boolean enabled = true;
        private int collectionInterval = 5000; // 5秒
        private boolean enableMetrics = true;
        private boolean enableTracing = true;
        private String storagePath = "./metrics";
    }
    
    /**
     * 安全审计模块配置属性
     */
    @Data
    public static class SecurityAuditModuleProperties {
        private boolean enabled = true;
        private boolean logEnabled = true;
        private boolean logTaskAccess = true;
        private boolean logDataAccess = true;
        private String auditLogPath = "./audit";
        private int retentionDays = 30;
    }
}