package pangea.hiagent.agent.data;

/**
 * 从Agent通用接口
 */
public interface SlaveAgent {
    AgentResult execute(SubTask subTask);

    /**
     * 降级方法，当执行失败时触发
     */
    default AgentResult fallback(SubTask subTask, Exception e) {
        AgentResult result = new AgentResult();
        result.setSuccess(false);
        result.setMessage("Fallback triggered: " + e.getMessage());
        result.setData(subTask.getFallbackData());
        return result;
    }
}