package pangea.hiagent.agent.data;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * Agent任务状态实体
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@TableName("agent_task_status")
public class AgentTaskStatus {
    private String taskId;
    private String status; // 任务状态：READY/RUNNING/SUCCESS/FAIL
    private String dependencies; // 依赖子任务ID，逗号分隔
    private String result; // 任务结果JSON字符串
    private String resultHash; // 结果MD5哈希值，用于校验完整性
    private Integer retryCount; // 已重试次数
    private Long timeout; // 任务超时时间戳
    private String validationStatus; // 校验状态：PASSED/FAILED/ERROR/NOT_VALIDATED
    private LocalDateTime updateTime; // 状态更新时间
}