package pangea.hiagent.agent.data;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 能力链构建器
 */
@Component
public class AgentChainBuilder {
    private final Map<String, SlaveAgent> agentMap;

    @Autowired
    public AgentChainBuilder(MasterAgent masterAgent) {
        this.agentMap = masterAgent.getAgentMap();
    }

    /**
     * 根据工具标签列表构建能力链
     */
    public AgentChain buildChain(List<String> toolTags) {
        AgentChain chain = new AgentChain();
        for (String tag : toolTags) {
            SlaveAgent agent = agentMap.get(tag);
            if (agent == null) {
                throw new IllegalArgumentException("Unknown tool tag: " + tag);
            }
            chain.addAgent(agent);
        }
        return chain;
    }
}