package pangea.hiagent.agent.data;

import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;

/**
 * 简单的幂等检查器实现
 * 在生产环境中，建议使用Redis等外部存储来保证跨实例的幂等性
 */
@Component
public class SimpleIdempotentChecker implements IdempotentChecker {
    
    private final Set<String> processedMessageIds = new HashSet<>();
    
    @Override
    public boolean check(String messageId) {
        // 如果消息ID已存在，说明已处理过，返回false
        if (processedMessageIds.contains(messageId)) {
            return false;
        }
        // 添加到已处理集合，并返回true表示可以处理
        processedMessageIds.add(messageId);
        return true;
    }
}