package pangea.hiagent.agent.data;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

/**
 * 日志审计模块自动配置
 * 基于@ConditionalOnProperty注解实现模块开关控制
 */
@Slf4j
@Component
@ConditionalOnProperty(prefix = "agent.module.log", name = "enabled", havingValue = "true", matchIfMissing = false)
public class LogModuleAutoConfig {
    
    /**
     * 监听Agent任务事件，记录全生命周期日志
     */
    @Async
    @EventListener
    public void handleAgentTaskEvent(AgentTaskEvent event) {
        log.info("记录Agent任务事件: taskId={}, eventType={}, timestamp={}", 
                event.getTaskId(), event.getEventType(), event.getTimestamp());
        
        // TODO 这里可以将日志持久化到数据库或发送到日志服务
        // 实现按taskId追溯链路的功能
    }
}