package pangea.hiagent.agent.data;

import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * 动态能力链定义
 */
@Slf4j
public class AgentChain {
    private final List<SlaveAgent> agentList = new ArrayList<>();

    public void addAgent(SlaveAgent agent) {
        agentList.add(agent);
    }

    /**
     * 链式执行：前一个Agent的输出作为下一个Agent的输入
     */
    public AgentResult execute(SubTask initialTask) {
        AgentResult currentResult = new AgentResult();
        currentResult.setData(initialTask.getParams());
        currentResult.setSuccess(true);

        for (SlaveAgent agent : agentList) {
            if (!currentResult.isSuccess()) {
                throw new AgentExecuteException("Chain execution stopped due to previous failure");
            }
            // 构造下一个Agent的输入任务
            SubTask nextTask = new SubTask();
            nextTask.setParams((java.util.Map<String, Object>) currentResult.getData());
            nextTask.setToolTag(getToolTag(agent));
            // 执行当前Agent
            currentResult = agent.execute(nextTask);
        }
        return currentResult;
    }

    /**
     * 获取Agent的ToolTag值
     */
    private String getToolTag(SlaveAgent agent) {
        ToolTag annotation = agent.getClass().getAnnotation(ToolTag.class);
        if (annotation != null) {
            return annotation.value();
        }
        throw new IllegalArgumentException("Agent does not have ToolTag annotation: " + agent.getClass().getName());
    }
}