package pangea.hiagent.agent.data;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 灰度执行器，支持按比例/白名单灰度发布新能力链
 */
@Component
public class GrayChainExecutor {
    private final AgentChainBuilder chainBuilder;
    private final int grayRatio;
    private final Set<String> whiteList;

    public GrayChainExecutor(AgentChainBuilder chainBuilder,
                             @Value("${agent.gray.ratio:10}") int grayRatio,
                             @Value("${agent.gray.white-list:test_task_001}") String whiteListStr) {
        this.chainBuilder = chainBuilder;
        this.grayRatio = grayRatio;
        this.whiteList = Set.of(whiteListStr.split(","));
    }

    /**
     * 执行灰度能力链
     */
    public AgentResult executeGray(List<String> grayTags, List<String> stableTags, SubTask task) {
        // 白名单任务优先使用灰度链
        if (whiteList.contains(task.getTaskId())) {
            return chainBuilder.buildChain(grayTags).execute(task);
        }
        // 按比例随机分配灰度流量
        int hash = Math.abs(task.getTaskId().hashCode() % 100);
        if (hash < grayRatio) {
            return chainBuilder.buildChain(grayTags).execute(task);
        }
        // 默认使用稳定链
        return chainBuilder.buildChain(stableTags).execute(task);
    }
}