package pangea.hiagent.agent.data;

import org.springframework.context.ApplicationEvent;

/**
 * Agent任务事件
 */
public class AgentTaskEvent extends ApplicationEvent {
    private final String taskId;
    private final String eventType;
    private final long timestamp;

    public AgentTaskEvent(Object source, String taskId, String eventType) {
        super(source);
        this.taskId = taskId;
        this.eventType = eventType;
        this.timestamp = System.currentTimeMillis();
    }

    public String getTaskId() {
        return taskId;
    }

    public String getEventType() {
        return eventType;
    }


}