package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * LLM配置实体类
 * 用于存储各种大语言模型的配置信息
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("llm_config")
public class LlmConfig extends BaseEntity {
    
    private static final long serialVersionUID = 1L;
    
    /**
     * 配置名称（唯一标识）
     */
    private String name;
    
    /**
     * 配置描述
     */
    private String description;
    
    /**
     * 模型提供商（openai, deepseek, ollama等）
     */
    private String provider;
    
    /**
     * 模型名称
     */
    private String modelName;
    
    /**
     * API密钥
     */
    private String apiKey;
    
    /**
     * API端点URL（适用于自定义或本地模型）
     */
    private String baseUrl;
    
    /**
     * 温度参数（0-2）
     */
    private Double temperature;
    
    /**
     * 最大生成Token数
     */
    private Integer maxTokens;
    
    /**
     * Top P参数
     */
    private Double topP;
    
    /**
     * 是否启用该配置
     */
    private Boolean enabled;
    
    /**
     * 配置所有者
     */
    private String owner;
    

}