package pangea.hiagent.agent.react;

import lombok.Data;

/**
 * ReAct步骤对象，包含步骤的所有核心信息
 */
@Data
public class ReactStep {
    
    /**
     * 步骤编号
     */
    private int stepNumber;
    
    /**
     * 步骤类型
     */
    private ReactStepType stepType;
    
    /**
     * 步骤核心内容（思维描述、动作指令、观察结果等）
     */
    private String content;
    
    /**
     * 工具调用信息（仅在ACTION步骤时有值）
     */
    private ToolCallAction action;
    
    /**
     * 工具观察结果（仅在OBSERVATION步骤时有值）
     */
    private ToolObservation observation;
    
    /**
     * 构造函数
     */
    public ReactStep() {}
    
    /**
     * 构造函数
     * @param stepNumber 步骤编号
     * @param stepType 步骤类型
     * @param content 步骤内容
     */
    public ReactStep(int stepNumber, ReactStepType stepType, String content) {
        this.stepNumber = stepNumber;
        this.stepType = stepType;
        this.content = content;
    }
    
    /**
     * 工具调用动作类
     */
    @Data
    public static class ToolCallAction {
        /**
         * 工具名称
         */
        private String toolName;
        
        /**
         * 工具调用参数
         */
        private Object parameters;
        
        public ToolCallAction() {}
        
        public ToolCallAction(String toolName, Object parameters) {
            this.toolName = toolName;
            this.parameters = parameters;
        }
    }
    
    /**
     * 工具观察结果类
     */
    @Data
    public static class ToolObservation {
        /**
         * 观察内容
         */
        private String content;
        
        public ToolObservation() {}
        
        public ToolObservation(String content) {
            this.content = content;
        }
    }
}