package pangea.hiagent.llm;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.stereotype.Component;

import pangea.hiagent.model.LlmConfig;

/**
 * LLM模型工厂类
 * 用于根据配置动态创建ChatModel实例
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class LlmModelFactory {
    
    private final ModelAdapterManager modelAdapterManager;
    
    /**
     * 根据配置创建ChatModel实例
     * 
     * @param config LLM配置
     * @return ChatModel实例
     */
    public ChatModel createChatModel(LlmConfig config) {
        return modelAdapterManager.createChatModel(config);
    }
    
    /**
     * 获取模型适配器管理器
     * 
     * @return ModelAdapterManager实例
     */
    public ModelAdapterManager getModelAdapterManager() {
        return modelAdapterManager;
    }
}