package pangea.hiagent.agent.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 错误处理工具类
 * 提供统一的错误处理方法，减少重复代码
 * 委托给ErrorHandlerService进行实际处理
 */
@Slf4j
@Component
public class ErrorHandlerUtils {
    
    private static ErrorHandlerService errorHandlerService;
    
    @Autowired
    public ErrorHandlerUtils(ErrorHandlerService errorHandlerService) {
        ErrorHandlerUtils.errorHandlerService = errorHandlerService;
    }
    
    /**
     * 构建完整的错误消息
     * 
     * @param errorMessage 基本错误信息
     * @param exception 异常对象
     * @param errorId 错误跟踪ID
     * @param processorType 处理器类型
     * @return 完整的错误消息
     */
    public static String buildFullErrorMessage(String errorMessage, Exception exception, String errorId, String processorType) {
        return errorHandlerService.buildFullErrorMessage(errorMessage, exception, errorId, processorType);
    }
    
    /**
     * 检查是否为未授权错误
     * 
     * @param exception 异常对象
     * @return 是否为未授权错误
     */
    public static boolean isUnauthorizedError(Exception exception) {
        return errorHandlerService.isUnauthorizedError(exception);
    }
    
    /**
     * 检查是否为超时错误
     * 
     * @param exception 异常对象
     * @return 是否为超时错误
     */
    public static boolean isTimeoutError(Exception exception) {
        return errorHandlerService.isTimeoutError(exception);
    }
    
    /**
     * 生成错误跟踪ID
     * 
     * @return 错误跟踪ID
     */
    public static String generateErrorId() {
        return errorHandlerService.generateErrorId();
    }
}