package pangea.hiagent.common.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

/**
 * SSE相关配置类
 * 负责配置SSE事件处理所需的线程池等资源
 */
@Configuration
public class SseConfig {
    
    /**
     * 创建共享的心跳任务执行器
     * 使用共享线程池以提高资源利用率
     * 
     * @return ScheduledExecutorService
     */
    @Bean
    public ScheduledExecutorService sharedHeartbeatExecutor() {
        // 创建一个固定大小的线程池，用于处理心跳任务
        // 线程池大小设置为2，足以处理常规的心跳任务
        return Executors.newScheduledThreadPool(2, r -> {
            Thread t = new Thread(r, "sse-heartbeat-thread");
            t.setDaemon(true); // 设置为守护线程，应用关闭时自动退出
            return t;
        });
    }
}