package pangea.hiagent.web.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 提示词模板DTO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PromptTemplateDto {
    private String id;
    private String name;
    private String description;
    private String templateContent;
    private String paramSchema;
    private String templateType;
    private Integer isSystem;
    private LocalDateTime createdAt;
    private LocalDateTime updatedAt;
    private String createdBy;
}
