package pangea.hiagent.common.config;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.BrowserType;
import com.microsoft.playwright.Playwright;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
public class PlaywrightConfig {
    @Value("${pangea.browser.url:ws://localhost:3000}")
    private String browserUrl;

    @Value("${pangea.browser.type:local}")
    private String browserType;

    @Bean
    public Playwright playwright() {
        log.info("playwright init success");

        return Playwright.create();
    }

    @Bean
    public Browser browser(Playwright playwright) {
        Browser browser = switch (browserType) {
            case "local" -> playwright.chromium().launch(new BrowserType.LaunchOptions()
                    .setHeadless(true)
                    .setArgs(java.util.Arrays.asList(
                            "--no-sandbox",
                            "--disable-dev-shm-usage",
                            "--disable-gpu",
                            "--remote-allow-origins=*")));
            case "remote" -> playwright.chromium().connect(browserUrl);
            default -> null;
        };
        if(browser != null) {
            browser.onDisconnected((tmp) -> {
                log.info("浏览器实例已断开连接");
                // 发送监听事件
                tmp.close();

            });
        }

        return browser;
    }

}
