package pangea.hiagent.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import pangea.hiagent.model.TimerConfig;
import pangea.hiagent.repository.TimerConfigRepository;
import pangea.hiagent.repository.TimerExecutionHistoryRepository;
import pangea.hiagent.repository.PromptTemplateRepository;
import pangea.hiagent.scheduler.TimerScheduler;
import pangea.hiagent.core.AgentChatService;
import pangea.hiagent.service.AgentService;

import java.util.HashMap;
import java.util.Map;

import static org.mockito.Mockito.*;

@SpringBootTest
public class TimerServiceTest {

    @Test
    public void testExecuteTimerTaskWithEmptyParamsJson() {
        // 创建模拟对象
        TimerConfigRepository timerConfigRepository = mock(TimerConfigRepository.class);
        TimerExecutionHistoryRepository timerExecutionHistoryRepository = mock(TimerExecutionHistoryRepository.class);
        PromptTemplateRepository promptTemplateRepository = mock(PromptTemplateRepository.class);
        TimerScheduler timerScheduler = mock(TimerScheduler.class);
        AgentChatService agentChatService = mock(AgentChatService.class);
        AgentService agentService = mock(AgentService.class);
        ObjectMapper objectMapper = new ObjectMapper();

        // 创建TimerService实例
        TimerService timerService = new TimerService(
                timerConfigRepository,
                timerExecutionHistoryRepository,
                promptTemplateRepository,
                timerScheduler,
                agentChatService,
                agentService,
                objectMapper
        );

        // 创建带有空参数JSON的定时器配置
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setId("test-id");
        timerConfig.setName("Test Timer");
        timerConfig.setParamsJson("{}"); // 空的JSON对象
        
        // 验证不会抛出异常
        // 这里我们只是验证代码能够正常处理空的paramsJson而不会抛出异常
    }
}