# 实现POP3邮件工具类

## 1. 添加依赖
在pom.xml中添加JavaMail API依赖，用于实现POP3邮件访问功能。

## 2. 创建邮件工具类
创建`EmailTools.java`文件，包含以下功能：

### 2.1 核心功能实现
- **获取今日所有邮件**：通过POP3协议连接邮箱，筛选今日收到的邮件，返回发件人和标题
- **获取所有未读邮件**：连接邮箱，筛选未读邮件，返回发件人和标题
- **获取指定邮件内容**：根据邮件ID获取邮件的详细内容
- **获取指定邮件附件**：根据邮件ID下载并保存附件
- **标记邮件为已读/未读**：修改邮件的阅读状态
- **删除指定邮件**：从邮箱中删除指定邮件

### 2.2 数据结构设计
- 定义请求参数类：包含邮箱服务器、端口、用户名、密码等必要信息
- 定义响应数据类：包含邮件ID、发件人、收件人、标题、日期、内容等信息
- 定义邮件附件数据类：包含附件名称、大小、内容类型等信息

### 2.3 工具方法
- 实现POP3连接管理（连接、断开连接）
- 实现邮件解析功能（解析邮件头、正文、附件）
- 实现日期筛选和格式转换
- 实现邮件状态管理

## 3. 代码实现要点
- 使用Spring的`@Component`和`@Tool`注解标记工具类和方法
- 使用Lombok的`@Slf4j`进行日志记录
- 处理异常情况，确保工具的健壮性
- 遵循现有工具类的代码风格和命名规范
- 提供清晰的工具描述和参数说明

## 4. 测试和验证
- 确保代码编译通过
- 验证各个方法的功能正确性
- 处理各种边界情况

通过以上步骤，实现一个功能完整、使用方便的POP3邮件工具类，满足用户的需求。