package pangea.hiagent.web.repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import pangea.hiagent.model.AgentToolRelation;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * Agent和Tool关系数据访问接口
 */
@Mapper
public interface AgentToolRelationRepository extends BaseMapper<AgentToolRelation> {
    
    /**
     * 根据Agent ID获取关联的Tool ID列表
     * @param agentId Agent ID
     * @return Tool ID列表
     */
    @Select("SELECT tool_id FROM agent_tool_relation WHERE agent_id = #{agentId} AND deleted = 0")
    List<String> getToolIdsByAgentId(@Param("agentId") String agentId);
    
    /**
     * 根据Tool ID获取关联的Agent ID列表
     * @param toolId Tool ID
     * @return Agent ID列表
     */
    @Select("SELECT agent_id FROM agent_tool_relation WHERE tool_id = #{toolId} AND deleted = 0")
    List<String> getAgentIdsByToolId(@Param("toolId") String toolId);
}