package pangea.hiagent.web.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import pangea.hiagent.web.repository.AgentDialogueRepository;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Slf4j
@Service
public class ChatService {

    @Autowired
    private AgentDialogueRepository agentDialogueRepository;

    private final ConcurrentMap<String,String> chatList = new ConcurrentHashMap<>(1024);

    public boolean chatExists(String userId,String agentId) {
        String chatId = buildChatId(userId,agentId);
        boolean exists = chatList.containsKey(chatId);
        if(!exists){
            log.info("put chatId:{}",chatId);
            chatList.put(chatId,"exists");
        }
        return exists;
    }

    public void removeChat(String userId,String agentId) {
        String chatId = buildChatId(userId,agentId);
        log.info("remove chatId:{}",chatId);
        chatList.remove(chatId);
        agentDialogueRepository.deleteDialogue(userId,agentId);
    }

    private String buildChatId(String userId,String agentId) {
        return  userId+"-"+agentId;
    }
}
