package pangea.hiagent.agent.service;

import java.util.function.Consumer;

/**
 * Token消费者接口，支持完成回调
 * 用于流式处理完成后执行特定操作
 */
public interface TokenConsumerWithCompletion extends Consumer<String> {
    /**
     * 当流式处理完成时调用
     * @param fullContent 完整的内容
     */
    default void onComplete(String fullContent) {
        // 默认实现为空
    }
}