package pangea.hiagent.workpanel;

import lombok.extern.slf4j.Slf4j;
import pangea.hiagent.workpanel.event.EventTypeConverter;

import java.util.HashMap;
import java.util.Map;

/**
 * 工作面板工具类
 * 提供各种辅助方法用于工作面板事件处理
 * 注意：此工具类已优化，移除了与EventTypeConverter重复的功能
 */
@Slf4j
public class WorkPanelUtils {
    
    /**
     * 将对象转换为Map（用于工具输入参数）
     */
    public static Map<String, Object> convertToMap(Object input) {
        if (input == null) {
            return new HashMap<>();
        }
        
        if (input instanceof Map) {
            // 安全地转换Map类型，确保键为String类型
            Map<?, ?> rawMap = (Map<?, ?>) input;
            Map<String, Object> resultMap = new HashMap<>();
            for (Map.Entry<?, ?> entry : rawMap.entrySet()) {
                // 将键转换为String类型
                String key = entry.getKey() != null ? entry.getKey().toString() : "null";
                resultMap.put(key, entry.getValue());
            }
            return resultMap;
        }
        
        // 简单对象转换为Map
        Map<String, Object> result = new HashMap<>();
        result.put("value", input);
        return result;
    }
    
    /**
     * 获取状态文本
     * 已委托给EventTypeConverter处理
     */
    public static String getStatusText(String status) {
        EventTypeConverter converter = new EventTypeConverter();
        return converter.getStatusText(status);
    }
    
    /**
     * 根据状态确定事件类型
     * 已委托给EventTypeConverter处理
     */
    public static String getEventTypeFromStatus(String status) {
        EventTypeConverter converter = new EventTypeConverter();
        return converter.getEventTypeFromStatus(status);
    }
    
    /**
     * 将对象转换为JSON字符串
     * 
     * @param obj 要转换的对象
     * @return JSON字符串表示
     */
    public static String convertToJsonString(Object obj) {
        if (obj == null) {
            return "null";
        }
        
        try {
            // 使用Jackson ObjectMapper进行序列化
            com.fasterxml.jackson.databind.ObjectMapper mapper = new com.fasterxml.jackson.databind.ObjectMapper();
            return mapper.writeValueAsString(obj);
        } catch (Exception e) {
            // 如果序列化失败，返回对象的toString()表示
            return obj.toString();
        }
    }
}