package pangea.hiagent.web.dto;

import lombok.Data;
import pangea.hiagent.model.Agent;
import pangea.hiagent.model.Tool;

import java.util.List;

/**
 * 包含工具信息的Agent DTO
 * 用于创建或更新Agent时同时传递Agent基本信息和工具关联信息
 */
@Data
public class AgentWithToolsDTO {
    /**
     * Agent基本信息
     */
    private Agent agent;
    
    /**
     * 关联的工具ID列表
     */
    private List<String> toolIds;
    
    /**
     * 关联的工具列表（可选）
     */
    private List<Tool> tools;
}