package pangea.hiagent.model;

import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.util.List;

/**
 * Agent实体类
 * 代表一个AI智能体
 */
@Slf4j
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@TableName("agent")
public class Agent extends BaseEntity {    
    private static final long serialVersionUID = 1L;
    
    /**
     * Agent名称
     */
    private String name;
    
    /**
     * Agent描述
     */
    private String description;
    
    /**
     * Agent状态（active/inactive/draft）
     */
    private String status;
    
    /**
     * 默认模型
     */
    private String defaultModel;
    
    /**
     * 系统提示词
     */
    private String systemPrompt;
    
    /**
     * 提示词模板
     */
    private String promptTemplate;
    
    /**
     * 温度参数（0-2）
     */
    private Double temperature;
    
    /**
     * 最大生成Token数
     */
    private Integer maxTokens;
    
    /**
     * Top P参数
     */
    private Double topP;
    
    /**
     * Top K参数
     */
    private Integer topK;
    
    /**
     * 存在惩罚
     */
    private Double presencePenalty;
    
    /**
     * 频率惩罚
     */
    private Double frequencyPenalty;
    
    /**
     * 历史记录长度
     */
    private Integer historyLength;    
    
    

    
    /**
     * 关联的RAG集合ID
     */
    private String ragCollectionId;
    
    /**
     * 是否启用RAG
     */
    private Boolean enableRag;
    
    /**
     * RAG检索的文档数量
     */
    private Integer ragTopK;
    
    /**
     * RAG相似度阈值
     */
    private Double ragScoreThreshold;
    
    /**
     * RAG提示词模板
     */
    private String ragPromptTemplate;
    
    /**
     * 是否启用ReAct Agent模式
     */
    private Boolean enableReAct;
    
    /**
     * 是否启用流式输出
     */
    private Boolean enableStreaming;
    
    /**
     * Agent所有者
     */
    private String owner;
    
    /**
     * 关联的工具列表（非数据库字段）
     */
    @com.baomidou.mybatisplus.annotation.TableField(exist = false)
    private List<Tool> tools;
}