package pangea.hiagent.common.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import pangea.hiagent.memory.CaffeineChatMemory;
import pangea.hiagent.memory.HybridChatMemory;
import pangea.hiagent.memory.RedisChatMemory;

import org.springframework.ai.chat.memory.ChatMemory;

/**
 * ChatMemory配置类
 * 配置Spring AI的ChatMemory用于管理对话历史
 * 支持多种实现：Redis、Caffeine或混合模式
 */
@Configuration
public class ChatMemoryConfig {
    
    // ChatMemory实现类型配置
    @Value("${app.chat-memory.implementation:hybrid}")
    private String implementation;
    
    /**
     * 配置ChatMemory Bean
     * 根据配置选择不同的实现
     */
    @Bean
    public ChatMemory chatMemory(
            CaffeineChatMemory caffeineChatMemory, 
            RedisChatMemory redisChatMemory,
            HybridChatMemory hybridChatMemory) {
        
        switch (implementation.toLowerCase()) {
            case "caffeine": 
                return caffeineChatMemory;
            case "redis": 
                return redisChatMemory;
            case "hybrid": 
            default: 
                return hybridChatMemory;
        }
    }
}