package pangea.hiagent.tools;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.ai.tool.annotation.Tool;

import java.time.LocalDateTime;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * 日期时间工具类
 * 提供日期和时间相关的功能
 */
@Slf4j
@Component
public class DateTimeTools {
    
    
    @Tool(description = "获取当前日期和时间")
    public String getCurrentDateTime() {
        String dateTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        log.debug("获取当前日期时间: {}", dateTime);
        return dateTime;
    }
    
    @Tool(description = "获取当前日期")
    public String getCurrentDate() {
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        log.debug("获取当前日期: {}", date);
        return date;
    }
}