import { AxiosResponse, AxiosRequestConfig } from 'axios'

interface UserInfo {
  id?: string
  username?: string
  email?: string
  [key: string]: any
}

interface AuthStore {
  token: { value: string | null }
  userInfo: { value: UserInfo }
  register: (username: string, password: string, email: string) => Promise<any>
  login: (username: string, password: string) => Promise<any>
  logout: () => void
  setUserInfo: (info: UserInfo) => void
  api: any
  get: (url: string, config?: AxiosRequestConfig) => Promise<AxiosResponse>
  post: (url: string, data?: any, config?: AxiosRequestConfig) => Promise<AxiosResponse>
  put: (url: string, data?: any, config?: AxiosRequestConfig) => Promise<AxiosResponse>
  del: (url: string, config?: AxiosRequestConfig) => Promise<AxiosResponse>
}

export declare function useAuthStore(): AuthStore