package pangea.hiagent.integration;

import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ActiveProfiles;
import pangea.hiagent.model.Agent;

import static org.junit.jupiter.api.Assertions.*;

/**
 * Agent工具集成测试类
 * 测试Agent工具配置的完整流程
 */
@SpringBootTest
@ActiveProfiles("test")
public class AgentToolsIntegrationTest {

    @Test
    void testAgentToolsConfigurationFlow() {
        // 测试Agent工具配置的整体流程
        
        // 1. 创建Agent实例
        Agent agent = new Agent();
        agent.setId("test-agent-001");
        agent.setName("测试Agent");
        
        // 2. 设置工具配置（JSON数组格式）
        agent.setTools("[\"search\", \"calculator\", \"weather\"]");
        
        // 3. 验证工具名称解析
        var toolNames = agent.getToolNames();
        assertNotNull(toolNames);
        assertEquals(3, toolNames.size());
        assertTrue(toolNames.contains("search"));
        assertTrue(toolNames.contains("calculator"));
        assertTrue(toolNames.contains("weather"));
        
        // 4. 验证工具名称集合去重
        agent.setTools("[\"search\", \"calculator\", \"search\"]");
        var toolNameSet = agent.getToolNameSet();
        assertNotNull(toolNameSet);
        assertEquals(2, toolNameSet.size());
        assertTrue(toolNameSet.contains("search"));
        assertTrue(toolNameSet.contains("calculator"));
        
        // 5. 测试单个工具名称
        agent.setTools("single-tool");
        toolNames = agent.getToolNames();
        assertNotNull(toolNames);
        assertEquals(1, toolNames.size());
        assertEquals("single-tool", toolNames.get(0));
        
        System.out.println("Agent工具配置集成测试完成");
    }
}