// package pangea.hiagent.tools;

// import com.microsoft.playwright.*;
// import com.microsoft.playwright.options.LoadState;
// import com.microsoft.playwright.options.WaitUntilState;
// import lombok.extern.slf4j.Slf4j;
// import org.springframework.ai.tool.annotation.Tool;
// import org.springframework.beans.BeansException;
// import org.springframework.context.ApplicationContext;
// import org.springframework.context.ApplicationContextAware;
// import org.springframework.stereotype.Component;
// import pangea.hiagent.workpanel.IWorkPanelDataCollector;

// import jakarta.annotation.PostConstruct;
// import jakarta.annotation.PreDestroy;
// import java.util.Base64;
// import java.util.HashMap;
// import java.util.List;
// import java.nio.file.Files;
// import java.nio.file.Path;

// /**
//  * Playwright网页自动化工具类
//  * 提供基于Playwright的网页内容抓取、交互操作、截图等功能
//  */
// @Slf4j
// @Component
// public class PlaywrightWebTools implements ApplicationContextAware {

//     // Spring应用上下文引用
//     private static ApplicationContext applicationContext;
    
//     // Playwright实例
//     private Playwright playwright;
    
//     // 浏览器实例
//     private Browser browser;
    
//     /**
//      * 初始化Playwright和浏览器实例
//      */
//     @PostConstruct
//     public void initialize() {
//         try {
//             log.info("正在初始化Playwright...");
//             this.playwright = Playwright.create();
//             // 使用chromium浏览器，无头模式（headless=true），适合服务器运行
//             this.browser = playwright.chromium().launch(new BrowserType.LaunchOptions().setHeadless(true));
//             log.info("Playwright初始化成功");
//         } catch (Exception e) {
//             log.error("Playwright初始化失败: ", e);
//         }
//     }
    
//     /**
//      * 销毁Playwright资源
//      */
//     @PreDestroy
//     public void destroy() {
//         try {
//             if (browser != null) {
//                 browser.close();
//                 log.info("浏览器实例已关闭");
//             }
//             if (playwright != null) {
//                 playwright.close();
//                 log.info("Playwright实例已关闭");
//             }
//         } catch (Exception e) {
//             log.error("Playwright资源释放失败: ", e);
//         }
//     }
    
//     /**
//      * 设置ApplicationContext引用
//      */
//     @Override
//     public void setApplicationContext(ApplicationContext context) throws BeansException {
//         PlaywrightWebTools.applicationContext = context;
//     }

//     /**
//      * 工具方法：获取指定URL的网页全部文本内容（去除HTML标签）
//      * @param url 网页地址（必填）
//      * @return 网页纯文本内容
//      */
//     @Tool(description = "获取网页纯文本内容")
//     public String getWebPageText(String url) {
//         log.debug("获取网页纯文本内容: {}", url);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         recordToWorkPanel("getWebPageText", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         // 空值校验，增强健壮性
//         if (url == null || url.isEmpty()) {
//             String errorMsg = "URL不能为空，请提供有效的网页地址";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("getWebPageText", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         // 创建浏览器上下文和页面
//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             // 导航到指定URL，等待页面加载完成
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             // 获取页面全部文本（Playwright的innerText会自动去除HTML标签，保留文本结构）
//             String content = page.locator("body").innerText();
//             long endTime = System.currentTimeMillis();
//             log.debug("成功获取网页文本内容，长度: {} 字符", content.length());
            
//             // 记录工具调用完成
//             recordToWorkPanel("getWebPageText", null, content, "success", endTime - startTime);
//             return content;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "获取网页内容失败：" + e.getMessage();
//             log.error("获取网页内容失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("getWebPageText", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 工具方法：获取网页中指定CSS选择器的元素内容
//      * @param url 网页地址
//      * @param cssSelector CSS选择器（如#title、.content）
//      * @return 元素的文本内容
//      */
//     @Tool(description = "获取网页指定元素的内容")
//     public String getWebElementText(String url, String cssSelector) {
//         log.debug("获取网页指定元素内容: {}, 选择器: {}", url, cssSelector);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         input.put("cssSelector", cssSelector);
//         recordToWorkPanel("getWebElementText", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         if (url == null || url.isEmpty() || cssSelector == null || cssSelector.isEmpty()) {
//             String errorMsg = "URL和CSS选择器不能为空";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("getWebElementText", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             Locator locator = page.locator(cssSelector);
//             // 检查元素是否存在
//             if (locator.count() == 0) {
//                 String errorMsg = "未找到匹配的元素：" + cssSelector;
//                 long endTime = System.currentTimeMillis();
//                 recordToWorkPanel("getWebElementText", null, errorMsg, "failure", endTime - startTime);
//                 return errorMsg;
//             }
//             String content = locator.innerText();
//             long endTime = System.currentTimeMillis();
//             log.debug("成功获取元素文本内容: {}", content);
            
//             // 记录工具调用完成
//             recordToWorkPanel("getWebElementText", null, content, "success", endTime - startTime);
//             return content;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "获取元素内容失败：" + e.getMessage();
//             log.error("获取元素内容失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("getWebElementText", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 工具方法：在网页指定输入框中输入文本
//      * @param url 网页地址
//      * @param inputSelector 输入框的CSS选择器（如#search-input）
//      * @param text 要输入的文本
//      * @return 操作结果
//      */
//     @Tool(description = "在网页输入框中输入文本")
//     public String inputTextToWebElement(String url, String inputSelector, String text) {
//         log.debug("在网页输入框中输入文本: {}, 选择器: {}, 文本: {}", url, inputSelector, text);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         input.put("inputSelector", inputSelector);
//         input.put("text", text);
//         recordToWorkPanel("inputTextToWebElement", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         if (url == null || url.isEmpty() || inputSelector == null || inputSelector.isEmpty() || text == null) {
//             String errorMsg = "URL、输入框选择器和输入文本不能为空";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("inputTextToWebElement", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             Locator inputLocator = page.locator(inputSelector);
//             if (inputLocator.count() == 0) {
//                 String errorMsg = "未找到输入框：" + inputSelector;
//                 long endTime = System.currentTimeMillis();
//                 recordToWorkPanel("inputTextToWebElement", null, errorMsg, "failure", endTime - startTime);
//                 return errorMsg;
//             }
//             // 聚焦并输入文本
//             inputLocator.click();
//             inputLocator.fill(text);
//             String result = "文本输入成功：" + text;
//             long endTime = System.currentTimeMillis();
//             log.debug("文本输入成功: {}", text);
            
//             // 记录工具调用完成
//             recordToWorkPanel("inputTextToWebElement", null, result, "success", endTime - startTime);
//             return result;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "输入文本失败：" + e.getMessage();
//             log.error("输入文本失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("inputTextToWebElement", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 工具方法：点击网页中的指定元素（按钮、链接等）
//      * @param url 网页地址
//      * @param elementSelector 元素的CSS选择器
//      * @return 操作结果
//      */
//     @Tool(description = "点击网页指定元素")
//     public String clickWebElement(String url, String elementSelector) {
//         log.debug("点击网页指定元素: {}, 选择器: {}", url, elementSelector);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         input.put("elementSelector", elementSelector);
//         recordToWorkPanel("clickWebElement", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         if (url == null || url.isEmpty() || elementSelector == null || elementSelector.isEmpty()) {
//             String errorMsg = "URL和元素选择器不能为空";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("clickWebElement", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             Locator locator = page.locator(elementSelector);
//             if (locator.count() == 0) {
//                 String errorMsg = "未找到要点击的元素：" + elementSelector;
//                 long endTime = System.currentTimeMillis();
//                 recordToWorkPanel("clickWebElement", null, errorMsg, "failure", endTime - startTime);
//                 return errorMsg;
//             }
//             // 点击元素，等待导航完成（如果是链接/提交按钮）
//             locator.click();
//             page.waitForLoadState(LoadState.LOAD);
//             String result = "元素点击成功，当前页面URL：" + page.url();
//             long endTime = System.currentTimeMillis();
//             log.debug("元素点击成功，当前页面URL: {}", page.url());
            
//             // 记录工具调用完成
//             recordToWorkPanel("clickWebElement", null, result, "success", endTime - startTime);
//             return result;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "点击元素失败：" + e.getMessage();
//             log.error("点击元素失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("clickWebElement", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 工具方法：获取网页全屏截图并保存到指定路径
//      * @param url 网页地址
//      * @param savePath 截图保存路径（如D:/screenshots/page.png）
//      * @return 操作结果
//      */
//     @Tool(description = "获取网页全屏截图")
//     public String captureWebPageScreenshot(String url, String savePath) {
//         log.debug("获取网页全屏截图: {}, 保存路径: {}", url, savePath);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         input.put("savePath", savePath);
//         recordToWorkPanel("captureWebPageScreenshot", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         if (url == null || url.isEmpty() || savePath == null || savePath.isEmpty()) {
//             String errorMsg = "URL和保存路径不能为空";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("captureWebPageScreenshot", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             // 截取全屏并保存
//             page.screenshot(new Page.ScreenshotOptions().setPath(java.nio.file.Paths.get(savePath)).setFullPage(true));
            
//             // 将截图文件转换为Base64编码，用于前端预览显示
//             String base64Image = "";
//             try {
//                 Path imagePath = java.nio.file.Paths.get(savePath);
//                 byte[] imageBytes = Files.readAllBytes(imagePath);
//                 base64Image = Base64.getEncoder().encodeToString(imageBytes);
//             } catch (Exception e) {
//                 log.warn("截图Base64编码转换失败: {}", e.getMessage());
//             }
            
//             String result = "截图成功，保存路径：" + savePath;
//             long endTime = System.currentTimeMillis();
//             log.debug("截图成功，保存路径: {}", savePath);
            
//             // 记录工具调用完成，并推送Base64截图到前端预览区域
//             HashMap<String, Object> output = new HashMap<>();
//             output.put("message", result);
//             if (!base64Image.isEmpty()) {
//                 output.put("previewImage", "data:image/png;base64," + base64Image);
//             }
//             recordToWorkPanel("captureWebPageScreenshot", null, output, "success", endTime - startTime);
//             return result;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "截图失败：" + e.getMessage();
//             log.error("截图失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("captureWebPageScreenshot", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 工具方法：提取网页中的所有超链接（a标签的href属性）
//      * @param url 网页地址
//      * @return 链接列表，以逗号分隔
//      */
//     @Tool(description = "提取网页中的所有链接")
//     public String extractAllLinksFromPage(String url) {
//         log.debug("提取网页中的所有链接: {}", url);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         recordToWorkPanel("extractAllLinksFromPage", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         if (url == null || url.isEmpty()) {
//             String errorMsg = "URL不能为空";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("extractAllLinksFromPage", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             // 获取所有a标签的href属性
//             Object result = page.locator("a").evaluateAll("elements => elements.map(el => el.href)");
//             List<String> links = (List<String>) result;
//             String resultStr = links.isEmpty() ? "未找到任何链接" : String.join(", ", links);
//             long endTime = System.currentTimeMillis();
//             log.debug("成功提取链接，数量: {}", links.size());
            
//             // 记录工具调用完成
//             recordToWorkPanel("extractAllLinksFromPage", null, resultStr, "success", endTime - startTime);
//             return resultStr;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "提取链接失败：" + e.getMessage();
//             log.error("提取链接失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("extractAllLinksFromPage", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 工具方法：在网页中执行自定义JavaScript代码，获取返回结果
//      * @param url 网页地址
//      * @param jsCode 要执行的JS代码（如"document.title"、"window.innerWidth"）
//      * @return JS执行结果
//      */
//     @Tool(description = "执行网页JavaScript代码")
//     public String executeJavaScriptOnPage(String url, String jsCode) {
//         log.debug("执行网页JavaScript代码: {}, JS代码: {}", url, jsCode);
        
//         // 记录工具调用开始
//         HashMap<String, Object> input = new HashMap<>();
//         input.put("url", url);
//         input.put("jsCode", jsCode);
//         recordToWorkPanel("executeJavaScriptOnPage", input, null, null);
        
//         long startTime = System.currentTimeMillis();
        
//         if (url == null || url.isEmpty() || jsCode == null || jsCode.isEmpty()) {
//             String errorMsg = "URL和JS代码不能为空";
//             long endTime = System.currentTimeMillis();
//             recordToWorkPanel("executeJavaScriptOnPage", null, errorMsg, "failure", endTime - startTime);
//             return errorMsg;
//         }

//         try (BrowserContext context = browser.newContext();
//              Page page = context.newPage()) {
//             page.navigate(url, new Page.NavigateOptions().setWaitUntil(WaitUntilState.LOAD));
//             // 执行JS代码并获取结果
//             Object result = page.evaluate(jsCode);
//             String resultStr = "JS执行结果：" + (result == null ? "null" : result.toString());
//             long endTime = System.currentTimeMillis();
//             log.debug("JS执行成功，结果: {}", resultStr);
            
//             // 记录工具调用完成
//             recordToWorkPanel("executeJavaScriptOnPage", null, resultStr, "success", endTime - startTime);
//             return resultStr;
//         } catch (Exception e) {
//             long endTime = System.currentTimeMillis();
//             String errorMsg = "执行JS失败：" + e.getMessage();
//             log.error("执行JS失败: ", e);
            
//             // 记录工具调用错误
//             recordToWorkPanel("executeJavaScriptOnPage", null, errorMsg, "error", endTime - startTime);
//             return errorMsg;
//         }
//     }
    
//     /**
//      * 记录到工作面板（不带执行时间）
//      */
//     private void recordToWorkPanel(String toolAction, Object input, Object output, String status) {
//         recordToWorkPanel(toolAction, input, output, status, null);
//     }
    
//     /**
//      * 记录到工作面板（带执行时间）
//      */
//     private void recordToWorkPanel(String toolAction, Object input, Object output, String status, Long executionTime) {
//         try {
//             // 首先尝试从Spring容器获取collector
//             IWorkPanelDataCollector collector = null;
//             if (applicationContext != null) {
//                 try {
//                     collector = applicationContext.getBean(IWorkPanelDataCollector.class);
//                 } catch (Exception e) {
//                     log.debug("通过Spring容器获取WorkPanelDataCollector失败: {}", e.getMessage());
//                 }
//             }
            
//             if (collector != null) {
//                 // 记录工具调用
//                 if (input != null && status == null) {
//                     // 调用开始
//                     collector.recordToolCallStart("Playwright网页工具", toolAction, input);
//                 } else if (status != null) {
//                     // 调用结束
//                     collector.recordToolCallComplete("Playwright网页工具", output, status, executionTime);
//                 }
//             } else {
//                 log.debug("无法记录到工作面板：collector为null");
//             }
//         } catch (Exception e) {
//             log.debug("记录工作面板失败", e);
//         }
//     }
// }