package pangea.hiagent.websocket;

import com.alibaba.fastjson2.annotation.JSONField;

/**
 * DOM同步的数据传输对象
 */
public class DomSyncData {
    // 消息类型：init（初始化完整DOM）、update（增量DOM更新）、style（样式）、script（脚本）、fragment（分片消息）
    @JSONField(name = "type")
    private String type;

    // DOM内容（完整/增量/分片）
    @JSONField(name = "dom")
    private String dom;

    // 样式内容（内联+外部）
    @JSONField(name = "style")
    private String style;

    // 脚本内容（内联+外部）
    @JSONField(name = "script")
    private String script;

    // 页面URL（用于前端匹配）
    @JSONField(name = "url")
    private String url;

    // 无参构造（JSON序列化需要）
    public DomSyncData() {}

    // 全参构造
    public DomSyncData(String type, String dom, String style, String script, String url) {
        this.type = type;
        this.dom = dom;
        this.style = style;
        this.script = script;
        this.url = url;
    }

    // getter/setter方法
    public String getType() { return type; }
    public void setType(String type) { this.type = type; }
    public String getDom() { return dom; }
    public void setDom(String dom) { this.dom = dom; }
    public String getStyle() { return style; }
    public void setStyle(String style) { this.style = style; }
    public String getScript() { return script; }
    public void setScript(String script) { this.script = script; }
    public String getUrl() { return url; }
    public void setUrl(String url) { this.url = url; }
}