@echo off
REM HiAgent 后端Debug启动脚本
REM 此脚本用于启动Spring Boot应用进行远程调试

setlocal enabledelayedexpansion

echo.
echo ========================================
echo   HiAgent 后端Debug调试启动
echo ========================================
echo.

@REM REM 设置DeepSeek API密钥（从环境变量或提示用户输入）
@REM if "%DEEPSEEK_API_KEY%"=="" (
@REM     echo 请输入您的DeepSeek API密钥:
@REM     set /p DEEPSEEK_API_KEY=""
@REM     echo.
@REM )

REM 检查Java是否安装
java -version >nul 2>&1
if errorlevel 1 (
    echo [ERROR] 未找到Java安装，请确保JDK 17+已安装
    pause
    exit /b 1
)

REM 进入后端目录
cd /d "%~dp0backend"

echo [INFO] 清理旧的构建文件...
call mvn clean -q

echo [INFO] 编译项目...
call mvn compile -q
if errorlevel 1 (
    echo [ERROR] 编译失败，请检查代码
    pause
    exit /b 1
)

echo [INFO] 启动应用（Debug模式）...
echo [INFO] 访问地址: http://localhost:8080
echo [INFO] Swagger UI: http://localhost:8080/swagger-ui.html
echo [INFO] 调试端口: 5005 (JDWP)
echo.

REM 启动应用，开启JDWP调试端口5005
set MAVEN_OPTS=-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005 -Dfile.encoding=UTF-8

call mvn spring-boot:run -Dspring-boot.run.arguments="--spring.jpa.hibernate.ddl-auto=create-drop"

pause