package pangea.hiagent.common.utils;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;

public class InputCodeGenerator {
    private static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final SecureRandom random = new SecureRandom();
    private static final AtomicLong sequence = new AtomicLong(0);

    public static String generateUniqueInputCode(String prefix) {
        // 当前时间戳（毫秒）
        long timestamp = System.currentTimeMillis();
        // 序列号
        long seq = sequence.incrementAndGet();

        // 组合时间戳和序列号
        long combined = (timestamp << 10) | (seq & 0x3FF); // 取序列号后10位

        // 转为36进制
        String code = Long.toString(Math.abs(combined), 36).toUpperCase();

        // 确保8位长度
        if (code.length() > 8) {
            code = code.substring(code.length() - 8);
        } else if (code.length() < 8) {
            // 前面补随机字符
            StringBuilder sb = new StringBuilder();
            for (int i = code.length(); i < 8; i++) {
                sb.append(CHARS.charAt(random.nextInt(CHARS.length())));
            }
            code = sb.toString() + code;
        }

        return prefix + code;
    }
}
