import { AxiosResponse, AxiosRequestConfig } from 'axios'

// 定义用户信息接口
interface UserInfo {
  id?: string
  username?: string
  email?: string
  [key: string]: any
}

// 定义认证响应数据接口
interface AuthResponseData {
  token: string
  [key: string]: any
}

// 定义API响应接口
interface ApiResponse<T = any> {
  code: number
  message: string
  data: T
}

interface AuthStore {
  token: { value: string | null }
  userInfo: { value: UserInfo }
  register: (username: string, password: string, email: string) => Promise<ApiResponse<AuthResponseData>>
  login: (username: string, password: string) => Promise<ApiResponse<AuthResponseData>>
  loginWithOAuth2: (providerName: string) => Promise<void>
  handleOAuth2Callback: () => Promise<ApiResponse<AuthResponseData>>
  loginWithOAuth2Code: (authCode: string, providerName: string) => Promise<ApiResponse<AuthResponseData>>
  logout: () => void
  setUserInfo: (info: UserInfo) => void
  api: any
  get: <T = any>(url: string, config?: AxiosRequestConfig) => Promise<AxiosResponse<T>>
  post: <T = any>(url: string, data?: any, config?: AxiosRequestConfig) => Promise<AxiosResponse<T>>
  put: <T = any>(url: string, data?: any, config?: AxiosRequestConfig) => Promise<AxiosResponse<T>>
  del: <T = any>(url: string, config?: AxiosRequestConfig) => Promise<AxiosResponse<T>>
}

export declare function useAuthStore(): AuthStore