package pangea.hiagent.config;

import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.openai.OpenAiEmbeddingModel;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * VectorStore配置类
 * 配置EmbeddingModel和VectorStore用于RAG功能
 */
@Configuration
public class VectorStoreConfig {

    /**
     * 配置OpenAI Embedding Model Bean
     */
    @Bean
    public EmbeddingModel embeddingModel() {
        // 使用默认的OpenAI API密钥和模型
        OpenAiApi openAiApi = new OpenAiApi.Builder().apiKey("fake-key").build(); // 使用假密钥避免错误
        return new OpenAiEmbeddingModel(openAiApi);
    }

    /**
     * 配置VectorStore Bean
     * 当前版本简单返回null，后续可以添加具体的VectorStore实现
     */
    @Bean
    @Primary
    public VectorStore vectorStore(EmbeddingModel embeddingModel) {
        // 暂时返回null，避免启动错误，RAG功能将不可用
        // 后续可以添加具体的VectorStore实现（如Milvus、PostgreSQL等）
        return null;
    }
}