package pangea.hiagent.agent.react;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.springframework.stereotype.Component;

@Component
public class EventSplitter {
    private final List<String> keywords = Arrays.asList(
                "Thought", "Action", "Observation", "Iteration_Decision", "Final_Answer"
        );
        private final Pattern keywordPattern = Pattern.compile(
                String.format("(%s):", String.join("|", keywords))
        );

        private String currentType = null;
        private StringBuilder currentContent = new StringBuilder();
        private StringBuilder buffer = new StringBuilder();

        private final ReactCallback callback;
        private volatile int stepNumber = 0;

        public EventSplitter(ReactCallback callback) {
            this.callback = callback;
        }

        // 每收到一个token/字符，调用此方法
        public void feedToken(String token) {
            buffer.append(token);
            Matcher matcher = keywordPattern.matcher(buffer);
            if (matcher.find()) {
                // 发现新事件
                if (currentType != null && currentContent.length() > 0) {
                    // 实时输出已分割事件
                    callback.onStep(new ReactStep(stepNumber++, ReactStepType.fromString(currentType), currentContent.toString()));
                }
                // 更新事件类型
                currentType = matcher.group(1);
                currentContent.setLength(0);
                // 移除关键词和冒号
                buffer.delete(0, matcher.end());
            }
            // 累积内容
            currentContent.append(buffer);
            buffer.setLength(0);
        }

        // 流式结束时，调用此方法输出最后一个事件
        public void endStream(ReactCallback tokenConsumer) {
            if (currentType != null && currentContent.length() > 0) {
                callback.onStep(new ReactStep(stepNumber++, ReactStepType.fromString(currentType), currentContent.toString()));
            }
        }
    }
