package pangea.hiagent.common.config;

import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * ChatModel配置类
 * 用于注册ChatModel和ChatClient.Builder bean，解决ChatClientAutoConfiguration找不到ChatModel的问题
 */
@Configuration
public class ChatModelConfig {
    
    /**
     * 注册ChatClient.Builder bean
     * 这个bean主要用于解决ChatClientAutoConfiguration中chatClientBuilder方法的依赖问题
     * 实际使用时我们会直接使用ChatModel创建ChatClient.Builder
     * 
     * @return ChatClient.Builder实例
     */
    @Bean
    public ChatClient.Builder chatClientBuilder() {
        // 返回一个默认的ChatClient.Builder，实际使用时会被替换
        return ChatClient.builder(new DummyChatModel());
    }
    
    /**
     * 虚拟ChatModel实现，仅用于满足Spring的依赖注入要求
     * 实际使用时我们会通过AgentService.getChatModelForAgent()获取真实的ChatModel实例
     */
    private static class DummyChatModel implements ChatModel {
        @Override
        public org.springframework.ai.chat.model.ChatResponse call(org.springframework.ai.chat.prompt.Prompt prompt) {
            throw new UnsupportedOperationException("Dummy ChatModel should not be used directly");
        }
    }
}