package pangea.hiagent.web.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * Agent请求DTO
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class AgentRequest {
    private String chatId;
    private String agentId;
    private String systemPrompt;
    private String userMessage;
    private String model;
    private Double temperature;
    private Integer maxTokens;
    private Double topP;
    private Boolean streaming;
    private List<String> tools;
}
