package pangea.hiagent.agent.processor;

import pangea.hiagent.model.Agent;
import pangea.hiagent.web.dto.AgentRequest;

import java.util.function.Consumer;

/**
 * 统一的Agent处理器接口
 * 为不同类型的Agent提供统一的处理接口
 */
public interface AgentProcessor {
    
    /**
     * 同步处理Agent请求
     * 
     * @param agent Agent对象
     * @param request 请求对象
     * @param userId 用户ID
     * @return 处理结果
     */
    String processRequest(Agent agent, AgentRequest request, String userId);
    
    /**
     * 流式处理Agent请求
     * 
     * @param request 请求对象
     * @param agent Agent对象
     * @param userId 用户ID
     * @param tokenConsumer token处理回调函数
     */
    void processStreamRequest(AgentRequest request, Agent agent, String userId, Consumer<String> tokenConsumer);
    
    /**
     * 获取处理器类型
     * 
     * @return 处理器类型字符串
     */
    String getProcessorType();
}